/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.manager;

import filenet.vw.api.VWExposedFieldDefinition;
import filenet.vw.api.VWIndexDefinition;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWQueue;
import filenet.vw.api.VWQueueDefinition;
import filenet.vw.api.VWSession;
import filenet.vw.apps.manager.IVWFolderOpenListener;
import filenet.vw.apps.manager.IVWFolderSelectionListener;
import filenet.vw.apps.manager.IVWMilestonesSelectionListener;
import filenet.vw.apps.manager.IVWQueueSelectionListener;
import filenet.vw.apps.manager.IVWWorkflowManagerActionListener;
import filenet.vw.apps.manager.VWFolderOpenEvent;
import filenet.vw.apps.manager.VWFolderSelectionEvent;
import filenet.vw.apps.manager.VWMilestonesSelectionEvent;
import filenet.vw.apps.manager.VWNodeInformation;
import filenet.vw.apps.manager.VWQueueSelectionEvent;
import filenet.vw.apps.manager.VWTreeCellRenderer;
import filenet.vw.apps.manager.VWWorkflowManagerActionEvent;
import filenet.vw.apps.manager.resources.VWResource;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.IVWMouseActionListener;
import filenet.vw.toolkit.utils.VWMouseAdapter;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.table.VWParticipantItem;
import filenet.vw.toolkit.utils.table.VWQuickSort;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.text.Collator;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class VWWorkflowManagerFolderPane
extends JPanel
implements TreeSelectionListener,
IVWFolderOpenListener,
IVWMouseActionListener,
ActionListener {
    private static final String DEFAULT_INDEX_NAME = "PWDefaultOrder";
    private JTree m_folderTree = null;
    private DefaultTreeModel m_treeModel = null;
    private EventListenerList m_queueListenerList = null;
    private EventListenerList m_folderListenerList = null;
    private EventListenerList m_actionListenerList = null;
    private EventListenerList m_milestonesListenerList = null;
    private Vector m_rootFolderNodes = null;
    private Vector m_userQueueFolderNodes = null;
    private Vector m_workQueueFolderNodes = null;
    private VWSession m_vwSession = null;
    private JPopupMenu m_folderPopupMenu = null;
    private JPopupMenu m_queuePopupMenu = null;
    private JMenuItem m_refreshFolderMenuItem = null;
    private JMenuItem m_refreshQueueMenuItem = null;
    private JMenuItem m_defineQueryMenuItem = null;
    private int m_contextX = 0;
    private int m_contextY = 0;
    private Collator m_collator = null;
    private Container m_parentContainer = null;
    private String m_userName = null;
    private boolean m_bFolderSelected = false;
    private VWNodeInformation m_selectedFolder = null;
    private boolean m_performQuery = false;

    public VWWorkflowManagerFolderPane(VWSession vwSession) {
        this.m_vwSession = vwSession;
        try {
            VWParticipant participant;
            if (this.m_vwSession != null && (participant = this.m_vwSession.fetchCurrentUserInfo().getNamePx()) != null) {
                VWParticipantItem participantItem = new VWParticipantItem(participant);
                this.m_userName = participantItem.getDisplayName();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        try {
            if (this.m_userName == null) {
                this.m_userName = VWResource.s_undefinedUserName;
            }
            this.m_queueListenerList = new EventListenerList();
            this.m_folderListenerList = new EventListenerList();
            this.m_actionListenerList = new EventListenerList();
            this.m_milestonesListenerList = new EventListenerList();
            this.m_collator = Collator.getInstance();
            VWNodeInformation nodeInfo = new VWNodeInformation(VWResource.s_eProcess);
            DefaultMutableTreeNode parentNode = new DefaultMutableTreeNode(nodeInfo);
            this.m_treeModel = new DefaultTreeModel(parentNode);
            this.createMainNodes(parentNode);
            this.initializeQueues();
            this.m_folderTree = new JTree(this.m_treeModel);
            this.m_folderTree.setCellRenderer(new VWTreeCellRenderer());
            this.m_folderTree.addTreeSelectionListener(this);
            this.m_folderTree.getSelectionModel().setSelectionMode(1);
            this.setLayout(new BorderLayout());
            this.add((Component)new JScrollPane(this.m_folderTree), "Center");
            this.m_defineQueryMenuItem = new JMenuItem(VWResource.s_defineQuery);
            this.m_defineQueryMenuItem.addActionListener(this);
            this.m_refreshFolderMenuItem = new JMenuItem(VWResource.s_refresh);
            this.m_refreshFolderMenuItem.addActionListener(this);
            this.m_refreshQueueMenuItem = new JMenuItem(VWResource.s_refresh);
            this.m_refreshQueueMenuItem.addActionListener(this);
            this.m_folderPopupMenu = new JPopupMenu();
            this.m_folderPopupMenu.add(this.m_refreshFolderMenuItem);
            this.m_queuePopupMenu = new JPopupMenu();
            this.m_queuePopupMenu.add(this.m_defineQueryMenuItem);
            this.m_queuePopupMenu.addSeparator();
            this.m_queuePopupMenu.add(this.m_refreshQueueMenuItem);
            this.m_folderTree.addMouseListener(new VWMouseAdapter(this));
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void selectRoot() {
        if (this.m_folderTree != null && this.m_treeModel != null) {
            this.m_folderTree.setSelectionPath(new TreePath(this.m_treeModel.getRoot()));
        }
    }

    public void refresh() {
        if (this.m_bFolderSelected) {
            this.initializeQueues();
            this.fireSelectionChanged(new VWFolderSelectionEvent(this, this.getFolderChildren(this.m_selectedFolder)));
        }
    }

    public void addQueueSelectionListener(IVWQueueSelectionListener listener) {
        this.m_queueListenerList.add(IVWQueueSelectionListener.class, listener);
    }

    public void removeQueueSelectionListener(IVWQueueSelectionListener listener) {
        this.m_queueListenerList.remove(IVWQueueSelectionListener.class, listener);
    }

    public void addFolderSelectionListener(IVWFolderSelectionListener listener) {
        this.m_folderListenerList.add(IVWFolderSelectionListener.class, listener);
    }

    public void removeFolderSelectionListener(IVWFolderSelectionListener listener) {
        this.m_folderListenerList.remove(IVWFolderSelectionListener.class, listener);
    }

    public void addMilestonesSelectionListener(IVWMilestonesSelectionListener listener) {
        this.m_milestonesListenerList.add(IVWMilestonesSelectionListener.class, listener);
    }

    public void removeMilestonesSelectionListener(IVWMilestonesSelectionListener listener) {
        this.m_milestonesListenerList.remove(IVWMilestonesSelectionListener.class, listener);
    }

    public void addWorkflowManagerActionListener(IVWWorkflowManagerActionListener listener) {
        this.m_actionListenerList.add(IVWWorkflowManagerActionListener.class, listener);
    }

    public void removeWorkflowManagerActionListener(IVWWorkflowManagerActionListener listener) {
        this.m_actionListenerList.remove(IVWWorkflowManagerActionListener.class, listener);
    }

    public void setParentContainer(Container parentContainer) {
        this.m_parentContainer = parentContainer;
    }

    public void initializeQueues() {
        block13: {
            try {
                DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)this.m_treeModel.getRoot();
                if (rootNode == null) break block13;
                Exception userQueueException = null;
                Exception publicQueueException = null;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.m_treeModel.getChild(rootNode, 0);
                if (node != null) {
                    try {
                        this.addUserQueueFolders(node);
                    }
                    catch (Exception ex) {
                        userQueueException = ex;
                    }
                }
                if ((node = (DefaultMutableTreeNode)this.m_treeModel.getChild(rootNode, 1)) != null) {
                    try {
                        this.addWorkQueueFolders(node);
                    }
                    catch (Exception ex) {
                        publicQueueException = ex;
                    }
                }
                if (userQueueException != null) {
                    if (publicQueueException != null) {
                        JOptionPane.showMessageDialog(this.m_parentContainer, VWResource.s_errorRetrievingUserAndPublicQueues, VWResource.s_errorMessage, 0);
                    } else {
                        JOptionPane.showMessageDialog(this.m_parentContainer, userQueueException, VWResource.s_errorRetrievingUserQueues, 0);
                    }
                } else if (publicQueueException != null) {
                    JOptionPane.showMessageDialog(this.m_parentContainer, publicQueueException, VWResource.s_errorRetrievingPublicQueues, 0);
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
    }

    public VWNodeInformation getCurrentNodeInformation() {
        try {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.m_folderTree.getLastSelectedPathComponent();
            if (node == null) {
                return null;
            }
            VWNodeInformation nodeInfo = (VWNodeInformation)node.getUserObject();
            if (nodeInfo == null) {
                return null;
            }
            return nodeInfo;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    public void valueChanged(TreeSelectionEvent event) {
        try {
            TreePath path = event.getPath();
            if (path == null) {
                return;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (node == null) {
                return;
            }
            VWNodeInformation nodeInfo = (VWNodeInformation)node.getUserObject();
            if (nodeInfo == null) {
                return;
            }
            switch (nodeInfo.getType()) {
                case 1: {
                    this.fireSelectionChanged(new VWFolderSelectionEvent(this, this.getFolderChildren(nodeInfo)));
                    this.m_bFolderSelected = true;
                    this.m_selectedFolder = nodeInfo;
                    break;
                }
                case 2: 
                case 3: {
                    this.fireSelectionChanged(new VWQueueSelectionEvent(this, nodeInfo, !this.m_performQuery));
                    this.m_bFolderSelected = false;
                    break;
                }
                case 4: {
                    this.fireSelectionChanged(new VWMilestonesSelectionEvent(this, nodeInfo, !this.m_performQuery));
                    this.m_bFolderSelected = false;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void folderOpened(VWFolderOpenEvent event) {
        int origMinSelRow = this.m_folderTree.getMinSelectionRow();
        if (origMinSelRow < 0) {
            origMinSelRow = 0;
        }
        this.m_folderTree.expandRow(origMinSelRow);
        int nSelectedRow = origMinSelRow + event.getRowIndex() + 1;
        boolean bExpandedRowOne = false;
        if (origMinSelRow == 0 && nSelectedRow == 2 && this.m_folderTree.isExpanded(1)) {
            bExpandedRowOne = true;
            this.m_folderTree.collapseRow(1);
        }
        this.m_folderTree.setSelectionRow(nSelectedRow);
        if (bExpandedRowOne) {
            this.m_folderTree.expandRow(1);
        }
    }

    public void createPopup(MouseEvent event) {
        this.m_contextX = event.getX();
        this.m_contextY = event.getY();
        TreePath selPath = this.m_folderTree.getPathForLocation(event.getX(), event.getY());
        if (selPath == null) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)selPath.getLastPathComponent();
        if (node == null) {
            return;
        }
        VWNodeInformation nodeInfo = (VWNodeInformation)node.getUserObject();
        if (nodeInfo == null) {
            return;
        }
        switch (nodeInfo.getType()) {
            case 1: {
                this.m_folderPopupMenu.show(event.getComponent(), event.getX(), event.getY());
                break;
            }
            case 2: {
                this.m_queuePopupMenu.show(event.getComponent(), event.getX(), event.getY());
                break;
            }
            case 3: {
                this.m_queuePopupMenu.show(event.getComponent(), event.getX(), event.getY());
                break;
            }
            case 4: {
                this.m_folderPopupMenu.show(event.getComponent(), event.getX(), event.getY());
            }
        }
    }

    public void doubleClickedItem(MouseEvent event) {
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (this.m_collator.compare(event.getActionCommand(), VWResource.s_refresh) == 0) {
                if (this.m_folderTree.getPathForLocation(this.m_contextX, this.m_contextY).getPathCount() == 2) {
                    this.m_folderTree.setSelectionRow(this.m_folderTree.getRowForLocation(this.m_contextX, this.m_contextY));
                    this.initializeQueues();
                } else if (this.m_folderTree.isRowSelected(this.m_folderTree.getRowForLocation(this.m_contextX, this.m_contextY))) {
                    this.fireActionEvent(new VWWorkflowManagerActionEvent(this, 3));
                } else {
                    this.m_folderTree.setSelectionRow(this.m_folderTree.getRowForLocation(this.m_contextX, this.m_contextY));
                }
                return;
            }
            if (this.m_collator.compare(event.getActionCommand(), VWResource.s_defineQuery) == 0) {
                this.m_performQuery = true;
                this.m_folderTree.setSelectionRow(this.m_folderTree.getRowForLocation(this.m_contextX, this.m_contextY));
                this.fireActionEvent(new VWWorkflowManagerActionEvent(this, 2));
                this.m_performQuery = false;
                return;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void createMainNodes(DefaultMutableTreeNode parentNode) {
        try {
            if (this.m_rootFolderNodes != null) {
                return;
            }
            this.m_rootFolderNodes = new Vector();
            VWNodeInformation nodeInfo = new VWNodeInformation(this.m_userName, 1);
            this.m_rootFolderNodes.addElement(nodeInfo);
            DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(nodeInfo);
            this.m_treeModel.insertNodeInto(childNode, parentNode, parentNode.getChildCount());
            nodeInfo = new VWNodeInformation(VWResource.s_workQueues, 1);
            this.m_rootFolderNodes.addElement(nodeInfo);
            childNode = new DefaultMutableTreeNode(nodeInfo);
            this.m_treeModel.insertNodeInto(childNode, parentNode, parentNode.getChildCount());
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void addUserQueueFolders(DefaultMutableTreeNode parentNode) throws Exception {
        try {
            DefaultMutableTreeNode childNode = null;
            if (this.m_userQueueFolderNodes != null) {
                this.m_userQueueFolderNodes.removeAllElements();
                for (int i = this.m_treeModel.getChildCount(parentNode); i > 0; --i) {
                    childNode = (DefaultMutableTreeNode)this.m_treeModel.getChild(parentNode, i - 1);
                    this.m_treeModel.removeNodeFromParent(childNode);
                }
            }
            if (this.m_vwSession == null) {
                return;
            }
            this.m_userQueueFolderNodes = new Vector();
            Vector<String> defaultDisplayFields = new Vector<String>();
            Object[] vwQueueNames = this.m_vwSession.fetchQueueNames(32);
            if (vwQueueNames == null) {
                return;
            }
            VWQuickSort quickSort = new VWQuickSort(vwQueueNames, 0);
            if (quickSort != null) {
                quickSort.sort(0, vwQueueNames.length - 1);
            }
            for (int i = 0; i < vwQueueNames.length; ++i) {
                VWExposedFieldDefinition exposedFieldDef;
                String defaultIndexName = null;
                int nIndex = ((String)vwQueueNames[i]).indexOf("(");
                if (nIndex != -1) {
                    vwQueueNames[i] = ((String)vwQueueNames[i]).substring(0, nIndex);
                }
                boolean bFound = false;
                if (!this.m_userQueueFolderNodes.isEmpty()) {
                    for (int s = 0; s < this.m_userQueueFolderNodes.size(); ++s) {
                        VWNodeInformation nodeInfo = (VWNodeInformation)this.m_userQueueFolderNodes.elementAt(s);
                        if (nodeInfo == null || VWStringUtils.compare(nodeInfo.getName(), (String)vwQueueNames[i]) != 0) continue;
                        bFound = true;
                        break;
                    }
                }
                if (bFound) continue;
                defaultDisplayFields.removeAllElements();
                VWQueue vwQueue = this.m_vwSession.getQueue((String)vwQueueNames[i]);
                VWQueueDefinition queueDefinition = vwQueue.fetchQueueDefinition();
                VWIndexDefinition[] indexes = queueDefinition.getIndexes();
                VWExposedFieldDefinition[] vwQueueExposedFields = queueDefinition.getFields();
                boolean bIsTrackerQueue = false;
                if (VWStringUtils.compare(vwQueue.getAuthoredName(), "Tracker") == 0) {
                    exposedFieldDef = queueDefinition.getField("F_CreateTime");
                    if (exposedFieldDef != null) {
                        defaultDisplayFields.addElement(exposedFieldDef.getName());
                    }
                    bIsTrackerQueue = true;
                } else {
                    exposedFieldDef = queueDefinition.getField("F_EnqueueTime");
                    if (exposedFieldDef != null) {
                        defaultDisplayFields.addElement(exposedFieldDef.getName());
                    }
                }
                exposedFieldDef = queueDefinition.getField("F_Subject");
                if (exposedFieldDef != null) {
                    defaultDisplayFields.addElement(exposedFieldDef.getName());
                }
                if (VWStringUtils.compare(vwQueue.getAuthoredName(), "Inbox") == 0) {
                    defaultDisplayFields.addElement("F_StepLabel");
                }
                for (int j = 0; j < vwQueueExposedFields.length; ++j) {
                    if (vwQueueExposedFields[j].isSystemField()) continue;
                    defaultDisplayFields.addElement(vwQueueExposedFields[j].getName());
                }
                for (int k = 0; k < indexes.length; ++k) {
                    if (VWStringUtils.compare(indexes[k].getName(), DEFAULT_INDEX_NAME) != 0) continue;
                    defaultIndexName = indexes[k].getName();
                }
                VWNodeInformation nodeInfo = new VWNodeInformation((String)vwQueueNames[i], 2, defaultIndexName, defaultDisplayFields, queueDefinition.hasFieldName("F_Overdue"), bIsTrackerQueue);
                this.m_userQueueFolderNodes.addElement(nodeInfo);
                childNode = new DefaultMutableTreeNode(nodeInfo);
                this.m_treeModel.insertNodeInto(childNode, parentNode, parentNode.getChildCount());
            }
            VWNodeInformation nodeInfo = new VWNodeInformation(VWResource.s_milestoneTracking, 4);
            this.m_userQueueFolderNodes.addElement(nodeInfo);
            childNode = new DefaultMutableTreeNode(nodeInfo);
            this.m_treeModel.insertNodeInto(childNode, parentNode, parentNode.getChildCount());
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            throw ex;
        }
    }

    private void addWorkQueueFolders(DefaultMutableTreeNode parentNode) throws Exception {
        try {
            DefaultMutableTreeNode childNode = null;
            if (this.m_workQueueFolderNodes != null) {
                this.m_workQueueFolderNodes.removeAllElements();
                for (int i = this.m_treeModel.getChildCount(parentNode); i > 0; --i) {
                    childNode = (DefaultMutableTreeNode)this.m_treeModel.getChild(parentNode, i - 1);
                    this.m_treeModel.removeNodeFromParent(childNode);
                }
            }
            if (this.m_vwSession == null) {
                return;
            }
            this.m_workQueueFolderNodes = new Vector();
            Vector<String> defaultDisplayFields = new Vector<String>();
            Object[] vwQueueNames = this.m_vwSession.fetchQueueNames(1);
            if (vwQueueNames == null) {
                return;
            }
            VWQuickSort quickSort = new VWQuickSort(vwQueueNames, 0);
            if (quickSort != null) {
                quickSort.sort(0, vwQueueNames.length - 1);
            }
            for (int i = 0; i < vwQueueNames.length; ++i) {
                VWQueue vwQueue;
                String defaultIndexName = null;
                int nIndex = ((String)vwQueueNames[i]).indexOf("(");
                if (nIndex != -1) {
                    vwQueueNames[i] = ((String)vwQueueNames[i]).substring(0, nIndex);
                }
                if ((vwQueue = this.m_vwSession.getQueue((String)vwQueueNames[i])) != null && (vwQueue.getIsConnectorQueue() || VWStringUtils.compare(vwQueue.getAuthoredName(), "Conductor") == 0)) continue;
                defaultDisplayFields.removeAllElements();
                VWQueueDefinition queueDefinition = this.m_vwSession.getQueue((String)vwQueueNames[i]).fetchQueueDefinition();
                VWIndexDefinition[] indexes = queueDefinition.getIndexes();
                VWExposedFieldDefinition[] vwQueueExposedFields = queueDefinition.getFields();
                VWExposedFieldDefinition exposedFieldDef = queueDefinition.getField("F_EnqueueTime");
                if (exposedFieldDef != null) {
                    defaultDisplayFields.addElement(exposedFieldDef.getName());
                }
                if ((exposedFieldDef = queueDefinition.getField("F_Subject")) != null) {
                    defaultDisplayFields.addElement(exposedFieldDef.getName());
                }
                defaultDisplayFields.addElement("F_StepLabel");
                for (int j = 0; j < vwQueueExposedFields.length; ++j) {
                    if (vwQueueExposedFields[j].isSystemField()) continue;
                    defaultDisplayFields.addElement(vwQueueExposedFields[j].getName());
                }
                for (int k = 0; k < indexes.length; ++k) {
                    if (VWStringUtils.compare(indexes[k].getName(), DEFAULT_INDEX_NAME) != 0) continue;
                    defaultIndexName = indexes[k].getName();
                }
                VWNodeInformation nodeInfo = new VWNodeInformation((String)vwQueueNames[i], 3, defaultIndexName, defaultDisplayFields, queueDefinition.hasFieldName("F_Overdue"), false);
                this.m_workQueueFolderNodes.addElement(nodeInfo);
                childNode = new DefaultMutableTreeNode(nodeInfo);
                this.m_treeModel.insertNodeInto(childNode, parentNode, parentNode.getChildCount());
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            throw ex;
        }
    }

    private VWNodeInformation[] getFolderChildren(VWNodeInformation folder) {
        if (this.m_rootFolderNodes.isEmpty()) {
            return null;
        }
        Vector srcFolders = null;
        srcFolders = folder.getName() == ((VWNodeInformation)this.m_rootFolderNodes.elementAt(0)).getName() ? this.m_userQueueFolderNodes : (folder.getName() == ((VWNodeInformation)this.m_rootFolderNodes.elementAt(1)).getName() ? this.m_workQueueFolderNodes : this.m_rootFolderNodes);
        if (srcFolders == null) {
            return null;
        }
        VWNodeInformation[] dstFolders = new VWNodeInformation[srcFolders.size()];
        for (int i = 0; i < srcFolders.size(); ++i) {
            dstFolders[i] = (VWNodeInformation)srcFolders.elementAt(i);
        }
        return dstFolders;
    }

    private void fireSelectionChanged(VWQueueSelectionEvent event) {
        if (event == null) {
            return;
        }
        Object[] listeners = this.m_queueListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != IVWQueueSelectionListener.class) continue;
            ((IVWQueueSelectionListener)listeners[i + 1]).selectionChanged(event);
        }
    }

    private void fireSelectionChanged(VWFolderSelectionEvent event) {
        if (event == null) {
            return;
        }
        Object[] listeners = this.m_folderListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != IVWFolderSelectionListener.class) continue;
            ((IVWFolderSelectionListener)listeners[i + 1]).selectionChanged(event);
        }
    }

    private void fireSelectionChanged(VWMilestonesSelectionEvent event) {
        if (event == null) {
            return;
        }
        Object[] listeners = this.m_milestonesListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != IVWMilestonesSelectionListener.class) continue;
            ((IVWMilestonesSelectionListener)listeners[i + 1]).selectionChanged(event);
        }
    }

    private void fireActionEvent(VWWorkflowManagerActionEvent event) {
        if (event == null) {
            return;
        }
        Object[] listeners = this.m_actionListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != IVWWorkflowManagerActionListener.class) continue;
            ((IVWWorkflowManagerActionListener)listeners[i + 1]).actionPerformed(event);
        }
    }
}

